// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 10, Aufgabe 4
// "Kundenkartei"
//
// ClientFile = {Client}.
// Client     = id lastName firstName Address Address.
// Address    = street number zipCode city.
//
// OrderFile  = {clientID Order}
// Order      = id price amount;
//
// Assumptions:
// - at most 1000 clients
// - at most 10 orders per client

//--------------------------------------------
// Data classes
//--------------------------------------------
class Client {
	int id;                  // client id
	String lastName;
	String firstName;
	Address priv, office;
	Order[] order;           // list of orders
	int nOrders;             // number of orders
}

class Address {
	String street;
	int number;
	int zipCode;
	String city;
}

class Order {
	int id;     // order id
	int price;  // price of a single item
	int amount; // number of items ordered
}

//--------------------------------------------
// Main class with business logic
//--------------------------------------------
public class A4 {
	static Client[] client;  // client "data base"
	static int nClients;
	
	//----- Input of clients file
	
	static Address readAddress() {
		Address a = new Address();
		a.street = In.readWord();
		a.number = In.readInt();
		a.zipCode = In.readInt();
		a.city = In.readWord();
		return a;
	}
	
	static Client readClient() {
		Client c = new Client();
		c.id = In.readInt();
		c.lastName = In.readWord();
		c.firstName = In.readWord();
		c.priv = readAddress();
		c.office = readAddress();
		c.order = new Order[10];
		c.nOrders = 0;
		if (In.done()) return c; else return null;
	}
	
	static void readClients() {
		client = new Client[1000];
		nClients = 0;
		In.open("clientFile");
		Client c = readClient();
		while (c != null) {
			client[nClients++] = c;
			c = readClient();
		}
		In.close();
	}
	
	//----- Input of orders file
	
	static Order readOrder() {
		Order o = new Order();
		o.id = In.readInt();
		o.price = In.readInt();
		o.amount = In.readInt();
		return o;
	}
	
	static void addOrder(int id, Order o) {
		int i = 0;
		while (i < nClients && client[i].id != id) i++;
		if (i >= nClients)
			Out.println("client " + id + " not found");
		else if (client[i].nOrders >= 10)
			Out.println("client " + id + " has more than 10 orders");
		else {
			client[i].order[client[i].nOrders++] = o;
		}
	}
	
	static void readOrders() {
		In.open("orderFile");
		int id = In.readInt();
		while (In.done()) {
			Order o = readOrder();
			addOrder(id, o);
			id = In.readInt();
		}
		In.close();
	}
	
	//----- Output of client "data base"
	
	static void printAddress(Address a) {
		Out.print(a.street + " " + a.number + ", " + a.zipCode + " " + a.city);
	}
	
	static void printOrder(Order o) {
		Out.println("  " + o.amount + " Stk. von Artikel " + o.id + ": " + o.price*o.amount);
	}
	
	static void printClients() {
		Out.open("output.txt");
		for (int i = 0; i < nClients; i++) {
			Client c = client[i];
			Out.println("Kunden-Nr.: " + c.id);
			Out.println(c.lastName + " " + c.firstName);
			Out.print("Privatadresse:     "); printAddress(c.priv); Out.println();
			Out.print("Geschaeftsadresse: "); printAddress(c.office); Out.println();
			Out.println("Bestellungen:");
			for (int j = 0; j < c.nOrders; j++) printOrder(c.order[j]);
			Out.println();
		}
		Out.close();
	}
	
	//----- main method
	
	public static void main(String args[]) {
		readClients();
		readOrders();
		printClients();
	}
}

/*
Sample input:

Client file
1000 Mueller Max Wiesenweg 10 4020 Linz Dametzstrasse 4 4020 Linz
1001 Maier Julia Dornacherstrasse 314 4040 Linz Hauptplatz 3 4020 Linz
1002 Huber Franz Pleschingerstrasse 45 4040 Plesching Altenbergerstrasse 69 4040 Linz

Orders file
1000 427 2000 1
1000 488 1700 2
1001 413 1069 2
1002 467 3450 3
1002 455 2470 1
*/